//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "private"

UiDropDownBase {
    id : uiDropDown

    leftMargin   : 0
    topMargin    : 4
    bottomMargin : 4
    sizeFollowsPopup : true
    hideCurrent      : false

    backgroundDelegate : UiCondensedDropDownBackground {
        width  : parent.width + 6
        height : parent.height
        x      : -6
    }

    delegate : Item {
        implicitHeight : 24
        implicitWidth  : Math.max(uiDropDown.width, label.implicitWidth + 12)

        Text {
            id : label

            text  : {
                if (typeof modelData === "string")
                    return modelData;

                if ("text" in modelData) {
                    return modelData.text;
                } else if ("name" in modelData) {
                    return modelData.name;
                }

                return modelData.toString();
            }
            font  : UiFonts.getFont(UiFonts.Light, 14)
            color : UiColors.getColor(UiColors.Black)
            x     : 6
            anchors {
                verticalCenter : parent.verticalCenter
            }
        }
    }

    highlightDelegate : Rectangle {
        color  : UiColors.getColor(UiColors.HoverGreen)
        x      : 1
        width  : uiDropDown.width + 5
        height : parent.height
    }

    labelDelegate : Text {
        text  : {
            if (!uiDropDown.currentElement)
                return "";

            if (typeof uiDropDown.currentElement === "string")
                return uiDropDown.currentElement;

            if ("text" in uiDropDown.currentElement) {
                return uiDropDown.currentElement.text;
            } else if ("name" in uiDropDown.currentElement) {
                return uiDropDown.currentElement.name;
            }

            return uiDropDown.currentElement.toString();
        }
        font  : UiFonts.getFont(UiFonts.Light, 14)
        color : UiColors.getColor(UiColors.Black)
        x     : uiDropDown.leftMargin
        y     : uiDropDown.topMargin
    }
}


